/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDaemonNotRunning
extends Task {
    private SupportedDaemons m_daemon;

    public TaskDaemonNotRunning(String[] nodeList, SupportedDaemons daemon) {
        super(nodeList);
        this.m_daemon = daemon;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)("Performing Daemon not configured and running verification task for daemon (" + this.m_daemon.getDaemonDisplayName() + ")"));
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("1352", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()}));
        this.checkDaemonNotConfigured();
        this.checkDaemonNotRunning();
        this.m_resultSet.traceResultSet("\n====ResultSet returned by TaskDaemonNotRunning verification task====\n");
        if (this.isFixupReqd() && this.m_resultSet.anyFailure()) {
            this.generateFixups();
        }
        return this.m_resultSet.allSuccess();
    }

    protected void checkDaemonNotConfigured() {
        ResultSet dmnConfiguredResultSet = new ResultSet();
        new GlobalExecution().checkDaemonConfigured(this.m_nodeList, this.m_daemon.getDaemonName(), dmnConfiguredResultSet);
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("1353", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.CONFIGURED, ReportUtil.STATUS);
        Hashtable t = dmnConfiguredResultSet.getResultTable();
        Enumeration e = t.keys();
        ResultSet resultSet = new ResultSet();
        while (e.hasMoreElements()) {
            String status;
            String configured;
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1 || result.getStatus() == 4) {
                Trace.out((String)("Daemon '" + this.m_daemon.getDaemonDisplayName() + "' is configured on node: '" + node + "'"));
                resultSet.addResult(node, 3);
                errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1359", true, (Object[])new String[]{this.m_daemon.getDaemonDisplayName(), node}), s_gMsgBundle, "1359");
                resultSet.addErrorDescription(node, errDesc);
                configured = ReportUtil.YES;
                status = ReportUtil.FAILED;
            } else if (result.getStatus() == 3) {
                Trace.out((String)("Daemon '" + this.m_daemon.getDaemonDisplayName() + "' is not configured on node: '" + node + "'"));
                resultSet.addResult(node, 1);
                configured = ReportUtil.NO;
                status = ReportUtil.PASSED;
            } else {
                Trace.out((String)("Daemon Lifelessness result couldn't be obtained from node: '" + node + "'"));
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7591", true, (Object[])new String[]{this.m_daemon.getDaemonDisplayName(), node}), s_msgBundle, "7591");
                resultSet.addErrorDescription(node, errDesc);
                resultSet.addResult(node, 2);
                configured = ReportUtil.UNKNOWN;
                status = ReportUtil.UNKNOWN;
            }
            ReportUtil.writeRecord(node, configured, status);
        }
        if (resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1355", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()}));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1357", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()}));
            ReportUtil.printErrorNodes(resultSet);
        }
        this.m_resultSet.uploadResultSet(resultSet);
    }

    protected void checkDaemonNotRunning() {
        ResultSet dmnRunningResultSet = new ResultSet();
        new GlobalExecution().checkDaemonLiveliness(this.m_nodeList, this.m_daemon.getDaemonName(), dmnRunningResultSet);
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("1354", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.RUNNING, ReportUtil.STATUS);
        Hashtable t = dmnRunningResultSet.getResultTable();
        Enumeration e = t.keys();
        ResultSet resultSet = new ResultSet();
        while (e.hasMoreElements()) {
            String status;
            String running;
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                Trace.out((String)("Daemon '" + this.m_daemon.getDaemonDisplayName() + "' is running on node: '" + node + "'"));
                resultSet.addResult(node, 3);
                errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1360", true, (Object[])new String[]{this.m_daemon.getDaemonDisplayName(), node}), s_gMsgBundle, "1360");
                resultSet.addErrorDescription(node, errDesc);
                running = ReportUtil.YES;
                status = ReportUtil.FAILED;
            } else if (result.getStatus() == 3) {
                Trace.out((String)("Daemon '" + this.m_daemon.getDaemonDisplayName() + "' is not running on node: '" + node + "'"));
                resultSet.addResult(node, 1);
                running = ReportUtil.NO;
                status = ReportUtil.PASSED;
            } else {
                Trace.out((String)("Daemon Lifelessness result couldn't be obtained from node: '" + node + "'"));
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7591", true, (Object[])new String[]{this.m_daemon.getDaemonDisplayName(), node}), s_msgBundle, "7591");
                resultSet.addErrorDescription(node, errDesc);
                resultSet.addResult(node, 2);
                running = ReportUtil.UNKNOWN;
                status = ReportUtil.UNKNOWN;
            }
            ReportUtil.writeRecord(node, running, status);
        }
        if (resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1356", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()}));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1358", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()}));
            ReportUtil.printErrorNodes(resultSet);
        }
        this.m_resultSet.uploadResultSet(resultSet);
    }

    protected void generateFixups() {
        FixupData fixDaemonData = new FixupData(null);
        Hashtable t = this.m_resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 3) continue;
            fixDaemonData.addParticipatingNode(node);
        }
        fixDaemonData.addFixupInstruction("NAME", this.m_daemon.getDaemonName());
        String message = "Created fixup with \n Daemon name (" + this.m_daemon.getDaemonName() + ")" + "\n to turn off the daemon on nodes " + VerificationUtil.strList2List(fixDaemonData.getFixableNodes());
        Trace.out((String)message);
        VerificationLogData.logInfo(message);
        this.setFixupData(fixDaemonData);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1350", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()});
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1351", false, (Object[])new String[]{this.m_daemon.getDaemonDisplayName()});
    }

    public static enum SupportedDaemons {
        AVAHI_DAEMON("avahi-daemon");

        private String m_dmnName = null;

        private SupportedDaemons(String name) {
            this.m_dmnName = name;
        }

        public String getDaemonName() {
            return this.m_dmnName;
        }

        public String getDaemonDisplayName() {
            return VerificationUtil.getDaemonDisplayName(this.m_dmnName);
        }
    }
}

